#ifndef LCD3Wire_h
#define LCD3Wire_h

#include <inttypes.h>

#define scs_a 0x00
#define scs_e 0x01
#define scs_i 0x02
#define scs_o 0x03
#define scs_u 0x04
#define scs_n 0x05
#define scs_N 0x06

class LCD3Wire {
public:
  LCD3Wire(int num_lines);
  void commandWrite(int value);
  void init();
  void print(int value);
  void printIn(char value[]);
  void clear();
  //non-core---------------
  void cursorTo(int line_num, int x);
  void leftScroll(int chars, int delay_time);
  void SpanishCharSet();
  //end of non-core--------

private:
  void pulseEnablePin();
  void pushByte(int value);
  void clockToSIPO();
};

#endif
